

DROP TABLE IF EXISTS `site_plugin_banners_items`;
CREATE TABLE `site_plugin_banners_items` (
  `item_id` int(11) NOT NULL,
  `item_cat` int(11) NOT NULL,
  `item_label` varchar(255) NOT NULL,
  `item_status` int(1) NOT NULL,
  `item_date` int(11) NOT NULL,
  `item_date_start` int(11) NOT NULL,
  `item_date_end` int(11) NOT NULL,
  `item_shows` int(11) NOT NULL,
  `item_unique_shows` int(11) NOT NULL,
  `item_clicks` int(11) NOT NULL,
  `item_unique_clicks` int(11) NOT NULL,
  `item_max_show` int(11) NOT NULL,
  `item_type` int(1) NOT NULL,
  `item_image` int(1) NOT NULL,
  `item_html` text NOT NULL,
  `item_link` text NOT NULL,
  `item_link_target` varchar(20) NOT NULL,
  `item_weight` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `site_plugin_banners_log`;
CREATE TABLE `site_plugin_banners_log` (
  `log_id` int(11) NOT NULL,
  `log_type` int(1) NOT NULL,
  `log_date` int(11) NOT NULL,
  `log_url` int(11) NOT NULL,
  `log_user_agent` text NOT NULL,
  `log_language` text NOT NULL,
  `log_remote_addr` varchar(20) NOT NULL,
  `log_referer` text NOT NULL,
  `log_page` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `site_plugin_banners_zones`;
CREATE TABLE `site_plugin_banners_zones` (
  `cat_id` int(11) NOT NULL,
  `cat_status` int(11) NOT NULL,
  `cat_show` int(2) NOT NULL,
  `cat_label` varchar(50) NOT NULL,
  `cat_perm` int(2) NOT NULL,
  `cat_perm_groups` text NOT NULL,
  `cat_device` varchar(20) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


ALTER TABLE `site_plugin_banners_items`
  ADD PRIMARY KEY (`item_id`);

ALTER TABLE `site_plugin_banners_log`
  ADD PRIMARY KEY (`log_id`),
  ADD UNIQUE KEY `log_id` (`log_id`),
  ADD KEY `log_remote_addr` (`log_remote_addr`);

ALTER TABLE `site_plugin_banners_zones`
  ADD PRIMARY KEY (`cat_id`);


ALTER TABLE `site_plugin_banners_items`
  MODIFY `item_id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `site_plugin_banners_log`
  MODIFY `log_id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `site_plugin_banners_zones`
  MODIFY `cat_id` int(11) NOT NULL AUTO_INCREMENT;


ALTER TABLE `site_plugin_banners_items`
ADD `item_link_type` int(1) NOT NULL AFTER `item_html`,
ADD `item_link_module` int(11) NOT NULL AFTER `item_link_type`,
ADD `item_link_global` int(11) NOT NULL AFTER `item_link_module`,
CHANGE `item_link` `item_link_link` text COLLATE 'utf8_general_ci' NOT NULL AFTER `item_link_global`,
ADD `item_link_rel` varchar(50) COLLATE 'utf8_general_ci' NOT NULL AFTER `item_link_target`;